from causallearn.search.ConstraintBased.FCI import fci
import time
import pandas as pd
data = pd.read_csv('./dataset/ETT-small/ETTh1.csv', header=0)
data = data.iloc[:, 1:]
data_array = data.values
# default parameters
g, edges = fci(data_array)
# # or customized parameters
# g, edges = fci(data, independence_test_method, alpha, depth, max_path_length,
#     verbose, background_knowledge, cache_variables_map)

# visualization
from causallearn.utils.GraphUtils import GraphUtils

pdy = GraphUtils.to_pydot(g)
pdy.write_png('FCI-ETTh1.png')